**********************************************************************************************
8/20/09:  ADDED 2006 & 2007 DATA.  
12/18/09:  ADDED 2008 DATA.  
11/3/10:  ADDED 2009 DATA.  
10/23/11:  ADDED 2010 DATA.  
12/20/12:  ADDED 2011 DATA.  
**********************************************************************************************;


***********************************************************************
PREDICT VALUES FOR THOSE WITH A MMY MATCH
***********************************************************************;
	DATA temp;
	SET carslib.master3;
	IF group GE 4 AND avg1 NE .;
	RUN;

	PROC REG DATA=carslib.master3 OUTEST=est_1;
	   WHERE group IN(1,2);
	   MODEL d_ln_rtotpurx = d_vehageyr2 d_vehageyr2_2 d_vehageyr2_3 d_nm_autotran 
							d_nm_pwrbrake d_nm_aircar d_nm_pwrsteer d_nm_diesel d_nm_sunroof 
							d_nm_turbochg d_nm_frwhldrv d_srx d_tcx d_fdx d_atx d_psx d_pbx d_acx 
							d_dsx d_ln_r_expend d_ed1 d_ed2 d_ed3 d_fam1 d_fam2 d_fam3 d_fam4 
							d_fam_size d_age_ref d_age_ref2 d_reg1-d_reg3 d_nm_regn /noint;
	   OUTPUT OUT=reg_out1 P=yhat R=resid;
	RUN;
	* ADJUST FOR FACT THAT GENERATING PREDICTED VALUES FOR LOGS (SEE BABY WOOLDRIDGE P. 208);
	* NOTE B/C THE REGRESSION IS DE-MEANED, NEED TO ADD BACK IN ESTIMATED DUMMIES: GAMMA_BAR
	  YHAT = (X)BETA-(XBAR)BETA
	  AVG1 = (XBAR)BETA+GAMMA_BAR
	  SO YHAT+AVG1 = (X)BETA+GAMMA_BAR
	  I VERIFIED THIS BY RUNNING THE ABOVE MODEL WITH ALL DUMMIES INLCUDED
	  IN UNIX, ~/JIM/POVERTY, I RAN sas -memsize 1800M cars_proc_glm &;
	DATA alpha_est;
	SET reg_out1(KEEP=yhat ln_rtotpurx avg1);
	  m_hat=EXP(yhat+avg1);
	  y=EXP(ln_rtotpurx);
	KEEP m_hat y;
	RUN;
	PROC REG DATA=alpha_est OUTEST=alpha1;
	   MODEL y = m_hat /noint;
	RUN;
	QUIT;

	PROC SCORE DATA=temp SCORE=est_1 OUT=pred_1 TYPE=PARMS;
		ID id avg1;
		VAR d_vehageyr2 d_vehageyr2_2 d_vehageyr2_3 d_nm_autotran 
							d_nm_pwrbrake d_nm_aircar d_nm_pwrsteer d_nm_diesel d_nm_sunroof 
							d_nm_turbochg d_nm_frwhldrv d_srx d_tcx d_fdx d_atx d_psx d_pbx d_acx 
							d_dsx d_ln_r_expend d_ed1 d_ed2 d_ed3 d_fam1 d_fam2 d_fam3 d_fam4
							d_fam_size d_age_ref d_age_ref2 d_reg1-d_reg3 d_nm_regn;

	RUN;

	DATA pred_1;
	IF _N_=1 THEN SET alpha1(KEEP=m_hat RENAME=(m_hat=alpha_adj1));
	SET pred_1;
	predval1=EXP(model1+avg1)*alpha_adj1;
	RUN;
	PROC MEANS;
	RUN;
	PROC SORT DATA=pred_1;
	BY id;
	RUN;

	***********************************************************************
	PREDICT VALUES FOR THOSE WITH A BROADER MAKE MATCH
	***********************************************************************;
	DATA temp_mk;
	SET carslib.master3;
	IF group IN(1,2,8);
	KEEP ln_rtotpurx vehageyr2 vehageyr2_2 vehageyr2_3 nm_autotran nm_pwrbrake nm_aircar nm_pwrsteer 
			nm_diesel nm_sunroof nm_turbochg nm_frwhldrv srx tcx fdx atx psx pbx acx dsx 
			ln_r_expend ed1 ed2 ed3 fam1 fam2 fam3 fam4 fam_size age_ref age_ref2 reg1-reg3 nm_regn
			make_year group id;
	RUN;

	PROC SORT DATA=temp_mk;
		BY make_year;
	RUN;
	*CALCULATE THE MEANS FOR THE ESTIMATION SAMPLE TO COMPUTE PREDICTED VALUES;
	PROC MEANS NOPRINT DATA=temp_mk;
	   BY make_year;
	   WHERE group IN(1,2) ;
	   VAR ln_rtotpurx vehageyr2 vehageyr2_2 vehageyr2_3 nm_autotran nm_pwrbrake nm_aircar nm_pwrsteer 
			nm_diesel nm_sunroof nm_turbochg nm_frwhldrv srx tcx fdx atx psx pbx acx dsx 
			ln_r_expend ed1 ed2 ed3 fam1 fam2 fam3 fam4 fam_size age_ref age_ref2 reg1-reg3 nm_regn;
	   OUTPUT OUT=mean_dat2 MEAN=mk_avg1-mk_avg35 STD=mk_std;
	RUN;

	DATA temp1 temp2;
	   MERGE temp_mk(IN=in1) 
			 mean_dat2(KEEP=make_year mk_avg1-mk_avg35 mk_std _FREQ_ RENAME=(_FREQ_=mk_count));
	   BY make_year;
	   IF in1;

	IF mk_avg1 NE .;

	ARRAY regvar(1:35) ln_rtotpurx vehageyr2 vehageyr2_2 vehageyr2_3 nm_autotran 
							nm_pwrbrake nm_aircar nm_pwrsteer nm_diesel nm_sunroof 
							nm_turbochg nm_frwhldrv srx tcx fdx atx psx pbx acx dsx 
							ln_r_expend ed1 ed2 ed3 fam1 fam2 fam3 fam4 fam_size age_ref 
							age_ref2 reg1-reg3 nm_regn;
	ARRAY varmean(1:35) mk_avg1-mk_avg35;
	ARRAY d_mean(1:35)	d2_ln_rtotpurx d2_vehageyr2 d2_vehageyr2_2 d2_vehageyr2_3 d2_nm_autotran 
							d2_nm_pwrbrake d2_nm_aircar d2_nm_pwrsteer d2_nm_diesel d2_nm_sunroof 
							d2_nm_turbochg d2_nm_frwhldrv d2_srx d2_tcx d2_fdx d2_atx d2_psx 
							d2_pbx d2_acx d2_dsx d2_ln_r_expend d2_ed1 d2_ed2 d2_ed3 
							d2_fam1 d2_fam2 d2_fam3 d2_fam4 d2_fam_size d2_age_ref d2_age_ref2 
							d2_reg1-d2_reg3 d2_nm_regn;

	DO t=1 TO 35;
	   d_mean(t)=regvar(t)-varmean(t);
	END;
	DROP t;

	IF group IN(1,2) THEN OUTPUT temp1;
	IF group=8 THEN OUTPUT temp2;

	RUN;

	PROC REG DATA=temp1 OUTEST=est_2;
	   MODEL d2_ln_rtotpurx = d2_vehageyr2 d2_vehageyr2_2 d2_vehageyr2_3 d2_nm_autotran 
							d2_nm_pwrbrake d2_nm_aircar d2_nm_pwrsteer d2_nm_diesel d2_nm_sunroof 
							d2_nm_turbochg d2_nm_frwhldrv d2_srx d2_tcx d2_fdx d2_atx d2_psx 
							d2_pbx d2_acx d2_dsx d2_ln_r_expend d2_ed1 d2_ed2 d2_ed3 
							d2_fam1 d2_fam2 d2_fam3 d2_fam4 d2_fam_size d2_age_ref d2_age_ref2 
							d2_reg1-d2_reg3 d2_nm_regn /noint;
	   OUTPUT OUT=reg_out2 P=yhat R=resid;
	RUN;
	* ADJUST FOR FACT THAT GENERATING PREDICTED VALUES FOR LOGS (SEE BABY WOOLDRIDGE P. 208);
	DATA alpha_est;
	SET reg_out2(KEEP=yhat ln_rtotpurx mk_avg1);
	  m_hat=EXP(yhat+mk_avg1);
	  y=EXP(ln_rtotpurx);
	KEEP m_hat y;
	RUN;
	PROC REG DATA=alpha_est OUTEST=alpha2;
	   MODEL y = m_hat /noint;
	RUN;
	QUIT;

	PROC SCORE DATA=temp2 SCORE=est_2 OUT=pred_2 TYPE=PARMS;
		ID id mk_avg1;
		VAR d2_vehageyr2 d2_vehageyr2_2 d2_vehageyr2_3 d2_nm_autotran 
							d2_nm_pwrbrake d2_nm_aircar d2_nm_pwrsteer d2_nm_diesel d2_nm_sunroof 
							d2_nm_turbochg d2_nm_frwhldrv d2_srx d2_tcx d2_fdx d2_atx d2_psx 
							d2_pbx d2_acx d2_dsx d2_ln_r_expend d2_ed1 d2_ed2 d2_ed3 
							d2_fam1 d2_fam2 d2_fam3 d2_fam4 d2_fam_size d2_age_ref d2_age_ref2 
							d2_reg1-d2_reg3 d2_nm_regn;
	RUN;

	DATA pred_2;
	IF _N_=1 THEN SET alpha2(KEEP=m_hat RENAME=(m_hat=alpha_adj2));
	SET pred_2(RENAME=(model1=model2));
	predval2=EXP(model2+mk_avg1)*alpha_adj2;
	KEEP id predval2 model2;
	RUN;
	PROC MEANS;
	RUN;

	PROC SORT DATA=pred_2;
	   BY id;
	RUN;

	***********************************************************************
	PREDICT VALUES FOR THOSE WITHOUT ANY MAKE OR YEAR MATCH
	***********************************************************************;
	DATA temp3 temp35;
	SET carslib.master3;
	* INCLUDE GROUP=9s BECAUSE SOME DON'T HAVE MISSING PREDVAL1;
	IF group IN(1,2,9,10); 

	IF vehicyb=100 THEN vtype1=1;
	   ELSE vtype1=0;
	IF vehicyb=110 THEN vtype2=1;
	   ELSE vtype2=0;
	IF vehicyb=120 THEN vtype3=1;
	   ELSE vtype3=0;
	IF vehicyb=130 THEN vtype4=1;
	   ELSE vtype4=0;
	IF vehicyb=140 THEN vtype5=1;
	   ELSE vtype5=0;
	IF vehicyb=150 THEN vtype6=1;
	   ELSE vtype6=0;
	IF vehicyb=160 THEN vtype7=1;
	   ELSE vtype7=0;
	IF vehicyb=170 THEN vtype8=1;
	   ELSE vtype8=0;
	IF vehicyb=180 THEN vtype9=1;
	   ELSE vtype9=0;
	IF vehicyb=200 THEN vtype10=1;
	   ELSE vtype10=0;

	KEEP vtype1-vtype10 vehageyr2 vehageyr2_2 vehageyr2_3 nm_autotran 
		nm_pwrbrake nm_aircar nm_pwrsteer nm_diesel nm_sunroof nm_turbochg nm_frwhldrv 
		srx tcx fdx atx psx pbx acx dsx ln_r_expend ed1 ed2 ed3 fam1 fam2 fam3 fam4
		fam_size age_ref age_ref2 reg1-reg3 nm_regn id group ln_rtotpurx;  
	 
	IF group IN(9,10) THEN OUTPUT temp3;
	IF group IN(1,2) THEN OUTPUT temp35;

	RUN;
	PROC REG DATA=temp35 OUTEST=est_3;
	   MODEL ln_rtotpurx = vehageyr2 vehageyr2_2 vehageyr2_3 nm_autotran 
							nm_pwrbrake nm_aircar nm_pwrsteer nm_diesel nm_sunroof 
							nm_turbochg nm_frwhldrv srx tcx fdx atx psx pbx acx 
							dsx ln_r_expend ed1 ed2 ed3 fam1 fam2 fam3 fam4 
							fam_size age_ref age_ref2 reg1-reg3 nm_regn vtype2-vtype10;
	   OUTPUT OUT=reg_out3 P=yhat R=resid;
	RUN;
	* ADJUST FOR FACT THAT GENERATING PREDICTED VALUES FOR LOGS (SEE BABY WOOLDRIDGE P. 208);
	DATA alpha_est;
	SET reg_out3(KEEP=yhat ln_rtotpurx);
	  m_hat=EXP(yhat);
	  y=EXP(ln_rtotpurx);
	KEEP m_hat y;
	RUN;
	PROC REG DATA=alpha_est OUTEST=alpha3;
	   MODEL y = m_hat /noint;
	RUN;
	QUIT;

	PROC SCORE DATA=temp3 SCORE=est_3 OUT=pred_3 TYPE=PARMS;
		ID id;
		VAR vehageyr2 vehageyr2_2 vehageyr2_3 nm_autotran 
							nm_pwrbrake nm_aircar nm_pwrsteer nm_diesel nm_sunroof 
							nm_turbochg nm_frwhldrv srx tcx fdx atx psx 
							pbx acx dsx ln_r_expend ed1 ed2 ed3 
							fam1 fam2 fam3 fam4 fam_size age_ref age_ref2 
							reg1-reg3 nm_regn vtype2-vtype10;
	RUN;
	DATA pred_3;
	IF _N_=1 THEN SET alpha3(KEEP=m_hat RENAME=(m_hat=alpha_adj3));
	SET pred_3(RENAME=(model1=model3));
	predval3=EXP(model3)*alpha_adj3;
	KEEP id predval3 model3;
	RUN;
	PROC MEANS;
	RUN;

	PROC SORT DATA=pred_3;
	BY id;
	RUN;


	***********************************************************************
	ESTIMATE DEPRECIATION RATES
	***********************************************************************;
	DATA temp4;
	SET carslib.master3;
	*restrict to mmy groups that have at least 2 vehicles that are not the same price;
	IF group IN(1,2) AND mmy_count GE 2 AND mmy_std2 GT 0 AND other_mm=0;

	IF vehageyr2 IN (0,1) AND vehnewu=1 THEN new1=1;
	   ELSE new1=0;
	IF vehageyr2 IN (0,1) AND vehnewu=2 THEN new2=1;
	   ELSE new2=0;
	new3=1-new1-new2;

	IF 0 LE vehageyr2 LE 2 THEN spline1=1;
	   ELSE spline1=0;
	IF 3 LE vehageyr2 LE 6 THEN spline2=1;
	   ELSE spline2=0;
	IF 7 LE vehageyr2 LE 10 THEN spline3=1;
	   ELSE spline3=0;

	age_s1=vehageyr2*spline1;
	age_s2=vehageyr2*spline2;
	age_s3=vehageyr2*spline3;

	ageXnew3=vehageyr2*new3;
	********create decade variable*************************;

	IF 1980<=yrmade2<1990 THEN decade_1=1;
		ELSE decade_1=0;
	IF 1990<=yrmade2<2000 THEN decade_2=1;
		ELSE decade_2=0;
	IF yrmade2>=2000 THEN decade_3=1;
		ELSE decade_3=0;

	KEEP ln_rtotpurx decade_1-decade_3 make id mmy_id2 vehageyr2 vehageyr2_2 
			vehageyr2_3 new1-new3 ageXnew3 spline1 spline2 spline3 age_s1 age_s2 age_s3;
	RUN;

	PROC SORT DATA=temp4;
		BY make;
	RUN;

	DATA temp4;
	SET temp4;
	BY make;
	RETAIN counter 0;
	IF FIRST.make THEN DO;
	   counter=counter+1;
	END;

	* THERE ARE 56 MAKES IN TEMP4;
	ARRAY make_(1:56);
	ARRAY ageXmake(1:56);
	DO t=1 TO 56;
	   IF counter=t THEN make_(t)=1;
	   ELSE make_(t)=0;
	********create variables that interact vehageyr with make dummies*******;
	   ageXmake(t)=vehageyr2*make_(t);
	END;
	DROP t;

	********create variables that interact vehagyr with decade dummies******;
	ARRAY ageXdecade(1:3);
	ARRAY dec_(1:3) decade_1-decade_3;
	DO t=1 TO 3;
	   ageXdecade(t)=vehageyr2*dec_(t);
	END;
	DROP t;

	RUN;

	proc sort data=temp4;
		by mmy_id2;
	run;	

	PROC STANDARD DATA=temp4 OUT=std_depreciation MEAN=0;
	   BY mmy_id2;
	   VAR ln_rtotpurx vehageyr2 vehageyr2_2 vehageyr2_3 make_1-make_56 new1 ageXnew3
			decade_1-decade_3 ageXmake1-ageXmake56 ageXdecade1-ageXdecade3 
			age_s1 age_s2 age_s3 spline1 spline2 spline3;
	RUN;

	PROC REG DATA=std_depreciation OUTEST=est_4;
	   MODEL ln_rtotpurx = vehageyr2 /noint;
	RUN;
	PROC REG DATA=std_depreciation OUTEST=est_5;
	   MODEL ln_rtotpurx = vehageyr2 vehageyr2_2 vehageyr2_3 /noint;
	RUN;
	PROC REG DATA=std_depreciation OUTEST=est_6;
	   MODEL ln_rtotpurx = vehageyr2 spline1 age_s1 spline2 age_s2 spline3 age_s3 /noint;
	RUN;
	PROC REG DATA=std_depreciation OUTEST=est_7;
	   MODEL ln_rtotpurx = vehageyr2 ageXmake2-ageXmake56 /noint;
	RUN;
	PROC REG DATA=std_depreciation OUTEST=est_8;
	   MODEL ln_rtotpurx = vehageyr2 ageXdecade2-ageXdecade3 /noint;
	RUN;


	***********************************************************************
	MERGE ALL INFO BACK WITH MASTER DATA
	***********************************************************************;
	*PROC SORT DATA=carslib.master3;
	*   BY id;
	*RUN;

	DATA carslib.master4(COMPRESS=YES);
	   MERGE carslib.master3(IN=in1) 
			pred_1(KEEP=id model1 predval1) 
			pred_2(KEEP=id predval2 model2) 
			pred_3(KEEP=id predval3 model3);
	   BY id;

	KEEP id newid model1 predval1 predval2 model2 predval3 model3 ln_rtotpurx totpurx mmy_id2 
		 year sv_year qyear group vehicyb vehageyr2 vehageyr2_2 vehageyr2_3 make yrmade2 own_for2 vehq
		 vehpuryr vehnewu sample r_totpurx ;
	RUN;

	DATA carslib.master4;
	   IF _N_=1 THEN SET est_4(KEEP=vehageyr2 RENAME=(vehageyr2=beta1));
	   IF _N_=1 THEN SET est_5(KEEP=vehageyr2 vehageyr2_2 vehageyr2_3 
					RENAME=(vehageyr2=beta2 vehageyr2_2=beta3 vehageyr2_3=beta4));
	   IF _N_=1 THEN SET est_6(KEEP=vehageyr2 spline1 age_s1 spline2 age_s2 spline3 age_s3
					RENAME=(vehageyr2=beta5 spline1=beta6 age_s1=beta7 spline2=beta8 age_s2=beta9
							spline3=beta10 age_s3=beta11));
	   IF _N_=1 THEN SET est_8(KEEP=vehageyr2 ageXdecade2 ageXdecade3 
					RENAME=(vehageyr2=beta12 ageXdecade2=beta13 ageXdecade3=beta14));
	   SET carslib.master4;

	*CONVERT COEFFICIENTS TO POSITIVE #S;
	*ARRAY betatemp(1:10) beta2-beta11;
	*DO t=1 TO 10;
	*	betatemp(t) = betatemp(t)*(-1);
	*END;

	IF vehageyr2 IN (0,1) AND vehnewu=1 THEN new1=1;
	   ELSE new1=0;
	IF vehageyr2 IN (0,1) AND vehnewu=2 THEN new2=1;
	   ELSE new2=0;
	new3=1-new1-new2;

	IF 0 LE vehageyr2 LE 2 THEN spline1=1;
	   ELSE spline1=0;
	IF 3 LE vehageyr2 LE 6 THEN spline2=1;
	   ELSE spline2=0;
	IF 7 LE vehageyr2 LE 10 THEN spline3=1;
	   ELSE spline3=0;

	age_s1=vehageyr2*spline1;
	age_s2=vehageyr2*spline2;
	age_s3=vehageyr2*spline3;

	********create decade variable*************************;

	IF 1980<=yrmade2<1990 THEN decade_1=1;
		ELSE decade_1=0;
	IF 1990<=yrmade2<2000 THEN decade_2=1;
		ELSE decade_2=0;
	IF yrmade2>=2000 THEN decade_3=1;
		ELSE decade_3=0;

	IF predval1 NE . THEN predval=predval1;
	   ELSE IF predval2 NE . THEN predval=predval2;
	   ELSE IF predval3 NE . THEN predval=predval3;


	**************************************************************************
	CALCULATE CPI-U FOR CARS
	COMES FROM PRICES_CARS.XLS, USES WGT'D AVG OF NEW AND USED CAR SERIES GIVEN 
	THAT ABOUT 60% OF ALL CARS ARE PURCHASED USED;
	**************************************************************************;
	* the oldest purchase year for group 2 is 1955;

	cpiu_rs_cars1=20.555;		* 1954;
	cpiu_rs_cars2=19.531;
	cpiu_rs_cars3=19.073;
	cpiu_rs_cars4=21.057;
	cpiu_rs_cars5=21.81;
	cpiu_rs_cars6=23.941;
	cpiu_rs_cars7=22.696;
	cpiu_rs_cars8=23.326;
	cpiu_rs_cars9=24.863;
	cpiu_rs_cars10=25.05;
	cpiu_rs_cars11=25.8;
	cpiu_rs_cars12=25.543;
	cpiu_rs_cars13=24.944;
	cpiu_rs_cars14=25.569;
	cpiu_rs_cars15=26.427;
	cpiu_rs_cars16=26.448;
	cpiu_rs_cars17=26.882;
	cpiu_rs_cars18=28.289;
	cpiu_rs_cars19=28.257;
	cpiu_rs_cars20=29.551;
	cpiu_rs_cars21=30.921;
	cpiu_rs_cars22=35.945;
	cpiu_rs_cars23=40.193;
	cpiu_rs_cars24=43.328;		* 1977;
	cpiu_rs_cars25=44.944;
	cpiu_rs_cars26=48.473;
	cpiu_rs_cars27=50.839;
	cpiu_rs_cars28=59.666;
	cpiu_rs_cars29=66.313;
	cpiu_rs_cars30=71.48;
	cpiu_rs_cars31=78.064;
	cpiu_rs_cars32=79.618;
	cpiu_rs_cars33=78.864;
	cpiu_rs_cars34=81.833;
	cpiu_rs_cars35=84.531;
	cpiu_rs_cars36=86.356;
	cpiu_rs_cars37=85.69;
	cpiu_rs_cars38=87.184;
	cpiu_rs_cars39=90.416;
	cpiu_rs_cars40=96.154;
	cpiu_rs_cars41=100.806;
	cpiu_rs_cars42=107.991;
	cpiu_rs_cars43=109.051;
	cpiu_rs_cars44=106.838;
	cpiu_rs_cars45=106.383;
	cpiu_rs_cars46=106.838;
	cpiu_rs_cars47=108.225;
	cpiu_rs_cars48=109.29;
	cpiu_rs_cars49=105.82;
	cpiu_rs_cars50=101.42;
	cpiu_rs_cars51=97.087;
	cpiu_rs_cars52=100; 		* 2005;
	cpiu_rs_cars53=100;
	cpiu_rs_cars54=98.619;
	cpiu_rs_cars55=97.561;
	cpiu_rs_cars56=97.572;	
	cpiu_rs_cars57=101.626;
	cpiu_rs_cars58=104.384;		
	cpiu_rs_cars59=105.263;		* 2012, place holder;



	* Need to discount reproted purchase price by the number of years since purchase
	  using the CPI-U_RS;
	ARRAY p(1:59) cpiu_rs_cars1-cpiu_rs_cars59;

	* THERE ARE SOME CARS PURCHASED BEFORE 1953, BUT NOT IN GROUP 3; 
	DO t=1 TO 59;   
	IF sv_year-1953=t THEN surv_cpi=p(t);
	IF vehpuryr NE . AND vehpuryr-1953=t THEN purch_cpi=p(t);
	   ELSE IF vehpuryr=. AND sv_year-ROUND(own_for2/12)-1953=t THEN purch_cpi=p(t);
	END; 
	 
	DROP t cpiu_rs_cars1-cpiu_rs_cars59;

	delta=1-EXP(beta1);
	**************************************************************************
	CALCULATE SERVICE FLOW IN 2005 DOLLARS
	**************************************************************************;
	IF group IN(1,2) THEN DO;
		vflow1=r_totpurx*delta;
		vflow2=r_totpurx*((-1*beta2)+2*(-1*beta3)*vehageyr2+3*(-1*beta4)*vehageyr2**2);
		vflow3=r_totpurx*(beta5+beta7*spline1+beta9*spline2+beta11*spline3)*(-1);
		vflow4=r_totpurx*(beta12+beta13*decade_2+beta14*decade_3)*(-1);
	END;
	IF group=3 THEN DO;
	* NOTE r_totpurx=totpurx*2005_cpi/surv_cpi, SO r_totpurx*surv_cpi/purch_cpi PUTS VEHICLE
	  VALUE IN REAL 2005 DOLLARS FOR CARS PURCHASED MORE THAN 12 MONTHS BEFORE INTERVIEW;
		vflow1=r_totpurx*surv_cpi/purch_cpi*delta*(1-delta)**ROUND(own_for2/12);
	*	vflow2=totpurx*(beta2+2*beta3*vehageyr2+3*beta4*vehageyr2**2)
					  *(1-(beta2+2*beta3*vehageyr2+3*beta4*vehageyr2**2))**(own_for2/12);
	*	vflow3=totpurx*(beta5+beta6*ageXdecade2+beta7*ageXdecade3
							+beta8*ageXdecade4+beta9*ageXdecade5)
					  *(1-(beta5+beta6*ageXdecade2+beta7*ageXdecade3
							+beta8*ageXdecade4+beta9*ageXdecade5))**(own_for2/12);
	END;
	IF group GE 4 THEN DO;
		vflow1=predval*delta;
		vflow2=predval*((-1*beta2)+2*(-1*beta3)*vehageyr2+3*(-1*beta4)*vehageyr2**2);
		vflow3=predval*(beta5+beta7*spline1+beta9*spline2+beta11*spline3)*(-1);
		vflow4=predval*(beta12+beta13*decade_2+beta14*decade_3)*(-1);
	END;

	*** GENERATE SURVEY YEAR THAT MATCHES WITH FAMILY FILE
	    THIS MATCHES BECAUSE IT IS GENERATED USING THE QYEAR
	    FROM THE CE SURVEY, SO DON'T NEED TO ADJUST FOR 
	    QUARTER 5;
	srv_year=floor(qyear/10)-1900;

	RUN;

	PROC SORT DATA=carslib.master4;
	   BY newid srv_year;
	RUN;
	PROC MEANS SUM NOPRINT DATA=carslib.master4;
	   BY newid srv_year;
	   VAR vflow1 vflow2 vflow3 vflow4;
	   OUTPUT OUT=tot_vdat SUM=tot_vflow1-tot_vflow4;
	RUN;

	DATA carslib.master4;
	   MERGE carslib.master4 
			 tot_vdat(KEEP=newid srv_year tot_vflow1-tot_vflow4 _FREQ_ 
					  RENAME=(_FREQ_=num_cars));
	   BY newid srv_year;
	RUN;

	**************************************************************************
	MAKE SAS DATASET TO MERGE WITH FAMILY FILE
	**************************************************************************;

	DATA carslib.car_values11;
	   SET carslib.master4(KEEP=newid srv_year tot_vflow1-tot_vflow4 num_cars sv_year group); 
	   BY newid srv_year;

	IF FIRST.newid OR FIRST.srv_year;

	* PUT VALUES BACK IN NOMINAL DOLLARS;
	* NOTE: THIS USES YEAR BECAUSE THAT'S WHAT'S USED IN MASTER6.SAS.  
	  IN FUTURE COULD USE REF_YEAR, BUT WOULD NEED TO BRING IN INTVMO
	  OR REF_YEAR FROM FAMILY FILE;

	**************************************************************************
	CALCULATE CPI-U-RS FOR CARS
	COMES FROM PRICES_CARS.XLS, USES WGT'D AVG OF NEW AND USED CAR SERIES GIVEN 
	THAT ABOUT 60% OF ALL CARS ARE PURCHASED USED;
	**************************************************************************;
	* the oldest purchase year for group 2 is 1955;

	cpiu_rs_cars1=20.555;		* 1954;
	cpiu_rs_cars2=19.531;
	cpiu_rs_cars3=19.073;
	cpiu_rs_cars4=21.057;
	cpiu_rs_cars5=21.81;
	cpiu_rs_cars6=23.941;
	cpiu_rs_cars7=22.696;
	cpiu_rs_cars8=23.326;
	cpiu_rs_cars9=24.863;
	cpiu_rs_cars10=25.05;
	cpiu_rs_cars11=25.8;
	cpiu_rs_cars12=25.543;
	cpiu_rs_cars13=24.944;
	cpiu_rs_cars14=25.569;
	cpiu_rs_cars15=26.427;
	cpiu_rs_cars16=26.448;
	cpiu_rs_cars17=26.882;
	cpiu_rs_cars18=28.289;
	cpiu_rs_cars19=28.257;
	cpiu_rs_cars20=29.551;
	cpiu_rs_cars21=30.921;
	cpiu_rs_cars22=35.945;
	cpiu_rs_cars23=40.193;
	cpiu_rs_cars24=43.328;		* 1977;
	cpiu_rs_cars25=44.944;
	cpiu_rs_cars26=48.473;
	cpiu_rs_cars27=50.839;
	cpiu_rs_cars28=59.666;
	cpiu_rs_cars29=66.313;
	cpiu_rs_cars30=71.48;
	cpiu_rs_cars31=78.064;
	cpiu_rs_cars32=79.618;
	cpiu_rs_cars33=78.864;
	cpiu_rs_cars34=81.833;
	cpiu_rs_cars35=84.531;
	cpiu_rs_cars36=86.356;
	cpiu_rs_cars37=85.69;
	cpiu_rs_cars38=87.184;
	cpiu_rs_cars39=90.416;
	cpiu_rs_cars40=96.154;
	cpiu_rs_cars41=100.806;
	cpiu_rs_cars42=107.991;
	cpiu_rs_cars43=109.051;
	cpiu_rs_cars44=106.838;
	cpiu_rs_cars45=106.383;
	cpiu_rs_cars46=106.838;
	cpiu_rs_cars47=108.225;
	cpiu_rs_cars48=109.29;
	cpiu_rs_cars49=105.82;
	cpiu_rs_cars50=101.42;
	cpiu_rs_cars51=97.087;
	cpiu_rs_cars52=100; 		* 2005;
	cpiu_rs_cars53=100;
	cpiu_rs_cars54=98.619;
	cpiu_rs_cars55=97.561;
	cpiu_rs_cars56=97.572;	
	cpiu_rs_cars57=101.626;
	cpiu_rs_cars58=104.384;		
	cpiu_rs_cars59=105.263;		* 2012, place holder;

	ARRAY p(1:59) cpiu_rs_cars1-cpiu_rs_cars59;

	* PUT IN NOMINAL TERMS; 
	DO t=1 TO 59;   
	   IF sv_year-1953=t THEN n_tot_vflow1=tot_vflow1*p(t)/100;
	   IF sv_year-1953=t THEN n_tot_vflow2=tot_vflow2*p(t)/100;
	   IF sv_year-1953=t THEN n_tot_vflow3=tot_vflow3*p(t)/100;
	   IF sv_year-1953=t THEN n_tot_vflow4=tot_vflow4*p(t)/100;
	END; 
	 
	DROP t cpiu_rs_cars1-cpiu_rs_cars59 sv_year;

	RUN;
	PROC MEANS DATA=carslib.car_values11;
	where srv_year=110;
	RUN;
	PROC MEANS DATA=carslib.car_values11;
	where srv_year=111;
	RUN;



ENDSAS;

	proc compare base=carslib.car_values10
	             compare=carslib.car_values09
				 novalues
	;	
	where srv_year LT 110;
	run;
PROC MEANS DATA=carslib.car_values_bak;
RUN;















**************************************************************************
DESCRIPTIVE STATS
**************************************************************************;
PROC MEANS DATA=carslib.master4;
WHERE vehageyr2 GT 10;
var vflow1 vflow2 vflow3 vflow4 own_for2 vehageyr2 group;
RUN;


**************************************************************************
VALIDATION TEST
**************************************************************************;
PROC SORT DATA=carslib.master4;
BY mmy_id2 vehageyr2;
RUN;
PROC MEANS NOPRINT DATA=carslib.master4;
   WHERE group IN(1,2,4,5,6,7) AND (mmy_id2-yrmade2*10000) NE 9999;
   BY mmy_id2 vehageyr2;
   VAR totpurx predval;
   OUTPUT OUT=temp_dat(DROP=_TYPE_) MEAN=;
RUN;
DATA temp_dat;
   SET temp_dat;
if group GT 2 THEN totpurx=.;
diff=predval-totpurx;
*diff2=(predval-totpurx)/totpurx;
RUN;
PROC UNIVARIATE;
where predval NE . AND totpurx NE .;
VAR diff predval totpurx;
RUN;

PROC MEANS NOPRINT DATA=carslib.master4;
   WHERE group IN(1,2,4,5,6,7) AND (mmy_id2-yrmade2*10000) NE 9999;
   BY mmy_id2;
   VAR totpurx predval;
   OUTPUT OUT=temp_dat(DROP=_TYPE_) MEAN=;
RUN;
DATA temp_dat;
   SET temp_dat;
if group GT 2 THEN totpurx=.;
diff=predval-totpurx;
*diff2=(predval-totpurx)/totpurx;
RUN;
PROC UNIVARIATE;
where predval NE . AND totpurx NE .;
VAR diff predval totpurx;
RUN;



PROC PRINT;
WHERE  XXXXX ABS(diff)>VAR diff;
RUN;






**************************************************************************
TO DO / CHECK
**************************************************************************;

* Regress purchase price on ed1 and mmy_id fe.  Compare predicted to actual
values.  Should be close if ed1 is close.

**************************************************************************
SCRATCH SCRATCH SCRATCH SCRATCH SCRATCH SCRATCH SCRATCH SCRATCH SCRATCH 
**************************************************************************;
PROC MEANS DATA=carslib.master3;
WHERE group IN(1,2) AND year LT 1988;
VAR nm_autotran nm_pwrbrake nm_aircar nm_pwrsteer 
		nm_diesel nm_sunroof nm_turbochg nm_frwhldrv year;
RUN;
PROC MEANS DATA=carslib.master3;
WHERE group IN(1,2) AND year GE 1988;
VAR nm_autotran nm_pwrbrake nm_aircar nm_pwrsteer 
		nm_diesel nm_sunroof nm_turbochg nm_frwhldrv year;
RUN;

PROC MEANS DATA=carslib.master3;
WHERE group GE 4 AND year LT 1988;
VAR nm_autotran nm_pwrbrake nm_aircar nm_pwrsteer 
		nm_diesel nm_sunroof nm_turbochg nm_frwhldrv year;
RUN;
PROC MEANS DATA=carslib.master3;
WHERE group GE 4 AND year GE 1988;
VAR nm_autotran nm_pwrbrake nm_aircar nm_pwrsteer 
		nm_diesel nm_sunroof nm_turbochg nm_frwhldrv year;
RUN;


PROC MEANS DATA=carslib.master3;
WHERE group IN(1,2);
VAR ed1 ed2 ed3 fam1 fam2 fam3 fam4
	fam_size age_ref age_ref2 reg1-reg3;
RUN;


data temp10;
set carslib.master4;
keep predval year yrmade2;
run;

proc univariate data=temp10;
var predval;
run;

proc sort data=temp10;
by year;
run;
proc FREQ data=temp10;
by year;
TABLE yrmade2;
run;



proc means data=temp10;
by year;
var predval;
run;
proc sort data=temp10;
by yrmade2;
run;
proc means data=temp10;
by yrmade2;
var predval;
run;




proc freq data=temp10;
where vehq NE num_cars;
table qyear;
*   var year vehpuryr purch own_for2;
run;

proc means;
var beta2 test;
run;
if group=3;
purch=year-ROUND(own_for2/12);
run;
proc means data=carslib.master3;
run;




DATA temp4;
SET carslib.master3;
*restrict to mmy groups that have at least 2 vehicles that are not the same price;


ln_rtotpurx=log(totpurx);

IF vehageyr2=1 THEN vehage_1=1;
ELSE IF vehageyr2=0 AND vehnewu=2  THEN vehage_1=1;
	ELSE vehage_1=0;



